/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.entities;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class KnightBossEntity
extends AbstractIllager
implements IAnimatable {
    protected static final EntityDataAccessor<Boolean> IS_PLAYING_ANIMATION = SynchedEntityData.m_135353_(KnightBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> MELEE_TYPE = SynchedEntityData.m_135353_(KnightBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> SKILL_TYPE = SynchedEntityData.m_135353_(KnightBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected int phase;
    protected int timer;
    protected int skillTimer;
    protected int phaseSwitchingTimer;
    protected List<Raider> teammatesList;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    protected KnightBossEntity(EntityType<? extends AbstractIllager> p_32105_, Level p_32106_) {
        super(p_32105_, p_32106_);
        this.f_21364_ = 50;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_PLAYING_ANIMATION, (Object)false);
        this.f_19804_.m_135372_(MELEE_TYPE, (Object)0);
        this.f_19804_.m_135372_(SKILL_TYPE, (Object)0);
        this.phase = -1;
        this.timer = 0;
        this.skillTimer = 0;
        this.phaseSwitchingTimer = 0;
        this.teammatesList = new ArrayList<Raider>();
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 4.0).m_22268_(Attributes.f_22279_, 0.28375).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor p_37856_, @NotNull DifficultyInstance p_37857_, @NotNull MobSpawnType mobSpawnType, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        this.phase = -1;
        if (mobSpawnType == MobSpawnType.COMMAND || mobSpawnType == MobSpawnType.SPAWNER || mobSpawnType == MobSpawnType.EVENT || mobSpawnType != MobSpawnType.SPAWN_EGG) {
            // empty if block
        }
        return super.m_6518_(p_37856_, p_37857_, mobSpawnType, p_37859_, p_37860_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
        this.registerAttackGoal();
    }

    protected void registerAttackGoal() {
        this.f_21345_.m_25352_(0, (Goal)new PhaseSwitchGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DeadGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new DoHurtTargetGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new UseSkillToHurtTargetGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ObserveTargetGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ObserveTargetWithHorseGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AttackWithHorseGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FullStrengthGoal(this));
    }

    public boolean m_6469_(@NotNull DamageSource p_37849_, float p_37850_) {
        if (this.phaseSwitchingTimer <= 0) {
            if (this.phase == 0 || this.phase == 0) {
                return false;
            }
            if (this.phase == 1) {
                return false;
            }
            if (this.phase == 2) {
                // empty if block
            }
            if (this.phase == 3) {
                // empty if block
            }
            if (this.phase == 4) {
                return false;
            }
            return super.m_6469_(p_37849_, p_37850_);
        }
        return false;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 1 && !this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public static void DestroyProjectiles(@Nonnull LivingEntity v, float range, float X, float Y, float Z, float arc) {
        for (Projectile entityHit : v.f_19853_.m_45976_(Projectile.class, v.m_20191_().m_82377_((double)X, (double)Y, (double)Z))) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - v.m_20189_(), entityHit.m_20185_() - v.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = v.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - v.m_20189_()) * (entityHit.m_20189_() - v.m_20189_()) + (entityHit.m_20185_() - v.m_20185_()) * (entityHit.m_20185_() - v.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || !(entityHit instanceof AbstractArrow)) continue;
            AbstractArrow arrow = (AbstractArrow)entityHit;
            if (arrow.f_36703_) continue;
            entityHit.m_20256_(entityHit.m_20184_().m_82490_(-0.1));
            entityHit.m_146922_(entityHit.m_146908_() + 180.0f);
            entityHit.f_19859_ += 180.0f;
        }
    }

    public void addTeammates(Raider raider) {
        this.teammatesList.add(raider);
    }

    public List<Raider> getTeammates() {
        return this.teammatesList;
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public SoundEvent m_7930_() {
        return null;
    }

    static class PhaseSwitchGoal
    extends Goal {
        protected final KnightBossEntity mob;

        public PhaseSwitchGoal(KnightBossEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    static class DeadGoal
    extends Goal {
        protected final KnightBossEntity mob;

        public DeadGoal(KnightBossEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    static class DoHurtTargetGoal
    extends Goal {
        protected final KnightBossEntity mob;

        public DoHurtTargetGoal(KnightBossEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    static class UseSkillToHurtTargetGoal
    extends Goal {
        protected final KnightBossEntity mob;

        public UseSkillToHurtTargetGoal(KnightBossEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    static class ObserveTargetGoal
    extends Goal {
        protected final KnightBossEntity mob;

        public ObserveTargetGoal(KnightBossEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    static class ObserveTargetWithHorseGoal
    extends Goal {
        protected final KnightBossEntity mob;

        public ObserveTargetWithHorseGoal(KnightBossEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    static class AttackWithHorseGoal
    extends Goal {
        protected final KnightBossEntity mob;

        public AttackWithHorseGoal(KnightBossEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    static class AttackGoal
    extends Goal {
        protected final KnightBossEntity mob;

        public AttackGoal(KnightBossEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    static class FullStrengthGoal
    extends Goal {
        protected final KnightBossEntity mob;

        public FullStrengthGoal(KnightBossEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
        }

        public boolean m_8036_() {
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }
    }

    public static class KnightBossHorseEntity
    extends Raider
    implements IAnimatable {
        AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

        protected KnightBossHorseEntity(EntityType<? extends Raider> p_37839_, Level p_37840_) {
            super(p_37839_, p_37840_);
        }

        @Nullable
        public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
            return super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
        }

        public void registerControllers(AnimationData data) {
        }

        public AnimationFactory getFactory() {
            return this.factory;
        }

        public void m_7895_(int p_37844_, boolean p_37845_) {
        }

        public SoundEvent m_7930_() {
            return null;
        }

        public boolean m_37882_() {
            return false;
        }

        protected void m_8099_() {
            super.m_8099_();
            this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
            this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
            this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
            this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
            this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
            this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
            this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
        }
    }
}

